<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
require_once __DIR__ . '/../includes/perm.php';
// Allow login/logout endpoints
$script = $_SERVER['SCRIPT_NAME'] ?? '';
$public = ['/login.php','/_api/login.php'];
if (!$public && !is_logged()){
  http_response_code(401);
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'msg'=>'auth-required']); exit;
}
// Role-based: allow all for admin; kasiyer limited to specific APIs
if (has_role('admin')) return;
$kasiyer_allowed = [
  '/_api/product-by-barcode.php',
  '/_api/sale-add.php',
  '/_api/customer-search.php',
  '/_api/customer-ledger.php',
  '/_api/export-sales-csv.php'
];
if (!in_array($script, $kasiyer_allowed, true)){
  http_response_code(403);
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit;
}