<?php
require_once __DIR__ . '/../includes/db.php';
$pdo = db();
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');
$pay  = $_GET['pay'] ?? '';
$q = "SELECT s.id,s.created_at,c.name AS customer,s.paytype,s.total FROM sales s LEFT JOIN customers c ON c.id=s.customer_id WHERE DATE(s.created_at) BETWEEN ? AND ?";
$p = [$from,$to];
if ($pay){ $q.=" AND s.paytype=?"; $p[]=$pay; }
$q.=" ORDER BY s.id DESC";
$stmt = $pdo->prepare($q); $stmt->execute($p);
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=sales.csv');
$out = fopen('php://output','w');
fputcsv($out, ['ID','Tarih','Müşteri','Ödeme','Toplam']);
while($r=$stmt->fetch()){ fputcsv($out, [$r['id'],$r['created_at'],$r['customer'],$r['paytype'],$r['total']]); }
fclose($out);