<?php
require_once __DIR__ . '/../includes/db.php';
header('Content-Type: application/json');
$payload = json_decode(file_get_contents('php://input'), true);
if (!$payload){ echo json_encode(['ok'=>false,'msg'=>'no-payload']); exit; }
$items = $payload['items'] ?? [];
$paytype = $payload['paytype'] ?? 'cash';
$paid = (float)($payload['paid'] ?? 0);
$customer_id = (int)($payload['customer_id'] ?? 0);
if (empty($items)){ echo json_encode(['ok'=>false,'msg'=>'no-items']); exit; }

$pdo = db();
$pdo->beginTransaction();
try {
  $total = 0.0;
  foreach($items as $it){ $total += ((float)$it['price']) * ((int)$it['qty']); }
  $stmt = $pdo->prepare("INSERT INTO sales (customer_id,total,paytype,paid) VALUES (?,?,?,?)");
  $stmt->execute([$customer_id ?: null, $total, $paytype, $paid]);
  $sale_id = (int)$pdo->lastInsertId();
  $itStmt = $pdo->prepare("INSERT INTO sale_items (sale_id,product_id,qty,unit_price) VALUES (?,?,?,?)");
  foreach($items as $it){
    $itStmt->execute([$sale_id, (int)$it['id'], (int)$it['qty'], (float)$it['price']]);
  }
  // Customer ledger: if customer and paid < total -> debt; if paid > total -> negative debt(tahsil)
  if ($customer_id){
    $diff = $total - $paid;
    if (abs($diff) > 0.0001){
      $type = $diff > 0 ? 'debt' : 'payment';
      $amt = abs($diff);
      $l = $pdo->prepare("INSERT INTO customer_ledger (customer_id,type,amount,note) VALUES (?,?,?,?)");
      $l->execute([$customer_id, $type, $amt, 'Satış #'.$sale_id]);
    }
  }
  $pdo->commit();
  echo json_encode(['ok'=>true,'sale_id'=>$sale_id,'total'=>$total]);
} catch (Throwable $e){
  $pdo->rollBack();
  echo json_encode(['ok'=>false,'msg'=>'SQL: '.$e->getMessage()]);
}