<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
$id = (int)($_GET['id'] ?? 0);
if (!$id){ header('Location:/customers.php'); exit; }
$customer = $pdo->prepare("SELECT * FROM customers WHERE id=?"); $customer->execute([$id]); $c = $customer->fetch();
$led = $pdo->prepare("SELECT * FROM customer_ledger WHERE customer_id=? ORDER BY created_at DESC");
$led->execute([$id]); $rows = $led->fetchAll();

$balance = 0.0;
foreach(array_reverse($rows) as $r){
  // debt positive, payment negative
  $balance += ($r['type']==='debt' ? 1 : -1) * (float)$r['amount'];
}
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Cari Ekstresi — <?= htmlspecialchars($c['name'] ?? '') ?></h2>
  <div class="label">Bakiye: <strong><?= number_format($balance,2) ?> ₺</strong></div>
  <form method="post" action="/_api/customer-ledger.php" class="grid grid-2" style="margin-top:12px">
    <input type="hidden" name="customer_id" value="<?= $id ?>">
    <div><label class="label">Tür</label><select name="type"><option value="debt">Borç</option><option value="payment">Tahsilat</option></select></div>
    <div><label class="label">Tutar</label><input class="input" type="number" step="0.01" name="amount" required></div>
    <div style="align-self:end"><button class="btn">Ekle</button></div>
  </form>
</div>
<div class="card">
  <h3>Hareketler</h3>
  <table class="table"><thead><tr><th>Tarih</th><th>Tür</th><th>Tutar</th><th>Açıklama</th></tr></thead><tbody>
  <?php foreach($rows as $r): ?>
    <tr><td><?= htmlspecialchars($r['created_at']) ?></td><td><?= htmlspecialchars($r['type']) ?></td><td><?= number_format((float)$r['amount'],2) ?> ₺</td><td><?= htmlspecialchars($r['note']) ?></td></tr>
  <?php endforeach; ?>
  </tbody></table>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>