<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
$page = max(1, (int)($_GET['p'] ?? 1));
$pp = 15;
$off = ($page-1)*$pp;
$total = $pdo->query("SELECT COUNT(*) AS c FROM customers")->fetch()['c'] ?? 0;
$rows = $pdo->query("SELECT id,name,phone,email FROM customers ORDER BY id DESC LIMIT $pp OFFSET $off")->fetchAll();
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Cariler</h2>
  <form method="post" action="/_api/customer-save.php" class="grid grid-2">
    <div><label class="label">Ad</label><input class="input" name="name" required></div>
    <div><label class="label">Telefon</label><input class="input" name="phone"></div>
    <div><label class="label">E-posta</label><input class="input" name="email"></div>
    <div style="align-self:end"><button class="btn" name="create" value="1">Ekle</button></div>
  </form>
</div>
<div class="card">
  <h3>Liste</h3>
  <table class="table"><thead><tr><th>ID</th><th>Ad</th><th>Telefon</th><th>E-posta</th><th>Detay</th></tr></thead><tbody>
  <?php foreach($rows as $r): ?>
    <tr><td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['name']) ?></td><td><?= htmlspecialchars($r['phone']) ?></td><td><?= htmlspecialchars($r['email']) ?></td>
      <td><a class="btn ghost" href="/customer-statement.php?id=<?= $r['id'] ?>">Aç</a></td></tr>
  <?php endforeach; ?>
  </tbody></table>
  <div class="flex">
    <div class="label">Toplam: <?= $total ?> kayıt</div>
    <div class="right">
      <?php if ($off>0): ?><a class="btn ghost" href="?p=<?= $page-1 ?>">Önceki</a><?php endif; ?>
      <?php if ($off+$pp<$total): ?><a class="btn ghost" href="?p=<?= $page+1 ?>">Sonraki</a><?php endif; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>