<?php
// PDO connection helper
function db() {
  static $pdo = null;
  if ($pdo) return $pdo;
  $cfg = include __DIR__ . '/config.php';
  $dsn = "mysql:host={$cfg['db']['host']};dbname={$cfg['db']['name']};charset={$cfg['db']['charset']}";
  try {
    $pdo = new PDO($dsn, $cfg['db']['user'], $cfg['db']['pass'], [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
  } catch (PDOException $e) {
    http_response_code(500);
    echo "DB ERROR: " . htmlspecialchars($e->getMessage());
    exit;
  }
  return $pdo;
}