<?php
// Role and permission helpers
function user() { return $_SESSION['user'] ?? null; }
function is_logged() { return !!user(); }
function has_role($role) { return is_logged() && (user()['role'] ?? '') === $role; }

// Page-based access using simple map
function can_access($page) {
  if (!is_logged()) return false;
  if (has_role('admin')) return true;
  // kasiyer rules: allow sale, customers view, basic reports view
  $kasiyer_allowed = [
    '/sale.php', '/customers.php', '/customer-statement.php'
  ];
  return in_array($page, $kasiyer_allowed, true);
}