<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $stmt = $pdo->prepare("INSERT INTO products (barcode,name,unit,vat,price) VALUES (?,?,?,?,?)");
  $stmt->execute([ $_POST['barcode'], $_POST['name'], $_POST['unit'], (float)$_POST['vat'], (float)$_POST['price'] ]);
  $msg = 'Ürün kaydedildi.';
}
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Ürün Ekle</h2>
  <?php if ($msg): ?><div class="badge"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <form method="post" class="grid grid-2">
    <div><label class="label">Barkod</label><input class="input" name="barcode" required></div>
    <div><label class="label">Ad</label><input class="input" name="name" required></div>
    <div><label class="label">Birim</label><input class="input" name="unit" value="Adet" required></div>
    <div><label class="label">KDV (%)</label><input class="input" type="number" step="0.01" name="vat" value="20"></div>
    <div><label class="label">Fiyat (KDV dahil)</label><input class="input" type="number" step="0.01" name="price" value="0"></div>
    <div style="align-self:end"><button class="btn">Kaydet</button></div>
  </form>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>