<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
$rows = $pdo->query("SELECT id, barcode, name, unit, vat, price FROM products ORDER BY id DESC LIMIT 500")->fetchAll();
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Ürünler (son 500)</h2>
  <table class="table"><thead><tr><th>ID</th><th>Barkod</th><th>Ad</th><th>Birim</th><th>KDV</th><th>Fiyat (KDV dahil)</th></tr></thead><tbody>
  <?php foreach($rows as $r): ?>
    <tr><td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['barcode']) ?></td><td><?= htmlspecialchars($r['name']) ?></td><td><?= htmlspecialchars($r['unit']) ?></td><td><?= (float)$r['vat'] ?>%</td><td><?= number_format((float)$r['price'],2) ?> ₺</td></tr>
  <?php endforeach; ?>
  </tbody></table>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>