<?php
require __DIR__ . '/includes/auth-guard.php';
include __DIR__ . '/includes/ui-header.php';
?>
<div class="grid grid-2">
  <div class="card">
    <h2>Satış</h2>
    <div class="grid">
      <div>
        <label class="label">Barkod (okut: <kbd>Enter</kbd>)</label>
        <input id="barcode" class="input" placeholder="Barkod okut veya yaz...">
      </div>
      <div>
        <label class="label">Cari Ara / Seç</label>
        <input id="customerSearch" class="input" placeholder="Müşteri adı veya telefon">
        <div id="customerPick" class="label"></div>
      </div>
    </div>
    <table class="table" id="cartTable">
      <thead><tr><th>Ürün</th><th>Birim Fiyat</th><th>Adet</th><th>Tutar</th><th></th></tr></thead>
      <tbody></tbody>
    </table>
    <div class="flex">
      <div><strong>Toplam:</strong> <span id="total">0.00</span> ₺</div>
      <div class="right">
        <button class="btn ghost" id="btnClear">Temizle</button>
      </div>
    </div>
  </div>
  <div class="card touchpad">
    <h3>Ödeme</h3>
    <div class="grid">
      <div>
        <label><input type="radio" name="paytype" value="cash" checked> Nakit</label>
        <label style="margin-left:12px"><input type="radio" name="paytype" value="card"> Kart</label>
        <label style="margin-left:12px"><input type="radio" name="paytype" value="mix"> Karışık</label>
      </div>
      <div>
        <label class="label">Ödenen</label>
        <input id="paid" class="input" type="number" step="0.01" value="0">
      </div>
      <div id="changeInfo" class="label"></div>
    </div>
    <div class="grid grid-2">
      <button class="btn" id="btnPrint">Yazdır</button>
      <button class="btn red" id="btnCheckout">Satışı Tamamla</button>
    </div>
  </div>
</div>

<div class="card" id="notFound" style="display:none">
  <div class="flex"><div class="label">Ürün bulunamadı.</div><div class="right">
    <button class="btn" id="btnAddNew">Yeni Ürün Ekle</button>
  </div></div>
</div>

<script>
const cart = [];
let customer_id = null;

function fmt(n){ return (Math.round(n*100)/100).toFixed(2); }
function recalc(){
  let t=0; cart.forEach(x=>t+=x.price * x.qty);
  document.getElementById('total').textContent = fmt(t);
  const paid = parseFloat(document.getElementById('paid').value||0);
  const diff = paid - t;
  const ci = document.getElementById('changeInfo');
  if (diff < 0){ ci.innerHTML = '<span class="kasa-eksik">Eksik: '+fmt(Math.abs(diff))+' ₺</span>'; }
  else { ci.innerHTML = '<span class="kasa-ok">Para üstü: '+fmt(diff)+' ₺</span>'; }
}

function render(){
  const tb = document.querySelector('#cartTable tbody');
  tb.innerHTML = '';
  cart.forEach((x,i)=>{
    const tr = document.createElement('tr');
    tr.innerHTML = `<td>${x.name}</td>
    <td>${fmt(x.price)} ₺</td>
    <td><input type="number" min="1" value="${x.qty}" style="width:70px" data-i="${i}" class="qty"></td>
    <td>${fmt(x.price*x.qty)} ₺</td>
    <td><button class="btn ghost rm" data-i="${i}">Sil</button></td>`;
    tb.appendChild(tr);
  });
  recalc();
}

document.getElementById('cartTable').addEventListener('input', e=>{
  if (e.target.classList.contains('qty')){
    const i = +e.target.dataset.i;
    cart[i].qty = Math.max(1, parseInt(e.target.value||1));
    render();
  }
});
document.getElementById('cartTable').addEventListener('click', e=>{
  if (e.target.classList.contains('rm')){
    cart.splice(+e.target.dataset.i,1);
    render();
  }
});

document.getElementById('paid').addEventListener('input', recalc);
document.getElementById('btnClear').addEventListener('click', ()=>{ cart.length=0; render(); });

document.getElementById('barcode').addEventListener('keydown', async (e)=>{
  if (e.key==='Enter'){
    const code = e.target.value.trim(); e.target.value='';
    if (!code) return;
    const r = await fetch('/_api/product-by-barcode.php?barcode='+encodeURIComponent(code));
    const j = await r.json();
    if (j.ok && j.product){
      const p = j.product;
      const idx = cart.findIndex(x=>x.id===p.id);
      if (idx>=0) cart[idx].qty += 1;
      else cart.push({id:p.id, name:p.name, price:parseFloat(p.price), qty:1});
      document.getElementById('notFound').style.display='none';
      render();
    } else {
      document.getElementById('notFound').style.display='block';
    }
  }
});

document.getElementById('btnAddNew').addEventListener('click', ()=>{
  window.location = '/product-new.php?from=sale';
});

// Customer search
document.getElementById('customerSearch').addEventListener('input', async (e)=>{
  const q = e.target.value.trim();
  customer_id = null;
  if (q.length<2){ document.getElementById('customerPick').textContent=''; return; }
  const r = await fetch('/_api/customer-search.php?q='+encodeURIComponent(q));
  const j = await r.json();
  const box = document.getElementById('customerPick');
  box.innerHTML = '';
  (j.items||[]).slice(0,5).forEach(it=>{
    const btn = document.createElement('button');
    btn.className = 'btn ghost'; btn.textContent = it.name+' ('+(it.phone||'-')+')';
    btn.onclick = ()=>{ customer_id = it.id; box.textContent = 'Seçildi: '+it.name; };
    box.appendChild(btn);
    box.append(' ');
  });
});

document.getElementById('btnCheckout').addEventListener('click', async ()=>{
  if (cart.length===0){ alert('Sepet boş'); return; }
  const paytype = document.querySelector('input[name=paytype]:checked').value;
  const paid = parseFloat(document.getElementById('paid').value||0);
  const r = await fetch('/_api/sale-add.php',{method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({items:cart, paytype, paid, customer_id})});
  const j = await r.json();
  if (j.ok){
    alert('Satış kaydedildi. No: '+j.sale_id);
    window.print(); // simple print as "Yazdır"
    cart.length=0; render();
  } else {
    alert('Hata: '+j.msg);
  }
});

document.getElementById('btnPrint').addEventListener('click', ()=> window.print());
</script>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>