<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');
$customer = (int)($_GET['customer'] ?? 0);
$pay = $_GET['pay'] ?? '';
$q = "SELECT s.id,s.created_at,s.customer_id,s.total,s.paytype,c.name AS customer_name
      FROM sales s LEFT JOIN customers c ON c.id=s.customer_id WHERE DATE(s.created_at) BETWEEN ? AND ?";
$params = [$from,$to];
if ($customer){ $q .= " AND s.customer_id=?"; $params[]=$customer; }
if ($pay){ $q .= " AND s.paytype=?"; $params[]=$pay; }
$q .= " ORDER BY s.id DESC LIMIT 500";
$stmt = $pdo->prepare($q); $stmt->execute($params);
$rows = $stmt->fetchAll();
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Satış Listesi</h2>
  <form class="grid grid-2">
    <div><label class="label">Tarih (başlangıç)</label><input class="input" type="date" name="from" value="<?= htmlspecialchars($from) ?>"></div>
    <div><label class="label">Tarih (bitiş)</label><input class="input" type="date" name="to" value="<?= htmlspecialchars($to) ?>"></div>
    <div><label class="label">Ödeme Türü</label>
      <select name="pay"><option value="">Hepsi</option><option <?= $pay==='cash'?'selected':'' ?> value="cash">Nakit</option><option <?= $pay==='card'?'selected':'' ?> value="card">Kart</option><option <?= $pay==='mix'?'selected':'' ?> value="mix">Karışık</option></select>
    </div>
    <div style="align-self:end"><button class="btn">Filtrele</button></div>
  </form>
  <table class="table"><thead><tr><th>ID</th><th>Tarih</th><th>Müşteri</th><th>Ödeme</th><th>Toplam</th></tr></thead><tbody>
  <?php foreach($rows as $r): ?>
    <tr><td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['created_at']) ?></td><td><?= htmlspecialchars($r['customer_name'] ?? '-') ?></td><td><?= htmlspecialchars($r['paytype']) ?></td><td><?= number_format((float)$r['total'],2) ?> ₺</td></tr>
  <?php endforeach; ?>
  </tbody></table>
  <div style="margin-top:10px">
    <a class="btn ghost" href="/_api/export-sales-csv.php?from=<?= urlencode($from) ?>&to=<?= urlencode($to) ?>&pay=<?= urlencode($pay) ?>">CSV</a>
  </div>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>