<?php
require __DIR__ . '/includes/auth-guard.php';
require __DIR__ . '/includes/db.php';
$pdo = db();
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['create'])) {
  $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, role, perms_json) VALUES (?,?,?,?)");
  $stmt->execute([$_POST['username'], password_hash($_POST['password'], PASSWORD_BCRYPT), $_POST['role'], json_encode($_POST['perms'] ?? []) ]);
  header('Location: /settings-users.php'); exit;
}
$users = $pdo->query("SELECT id,username,role,perms_json FROM users ORDER BY id DESC LIMIT 200")->fetchAll();
include __DIR__ . '/includes/ui-header.php';
?>
<div class="card">
  <h2>Kullanıcı Yönetimi</h2>
  <form method="post" class="grid grid-2">
    <div>
      <label class="label">Kullanıcı Adı</label><input class="input" name="username" required>
    </div>
    <div>
      <label class="label">Şifre</label><input class="input" type="password" name="password" required>
    </div>
    <div>
      <label class="label">Rol</label>
      <select name="role"><option value="admin">admin</option><option value="kasiyer">kasiyer</option></select>
    </div>
    <div>
      <div class="label">Erişim (sayfa bazlı)</div>
      <label><input type="checkbox" name="perms[]" value="/sale.php"> Satış</label><br>
      <label><input type="checkbox" name="perms[]" value="/products.php"> Ürünler</label><br>
      <label><input type="checkbox" name="perms[]" value="/product-new.php"> Ürün Ekle</label><br>
      <label><input type="checkbox" name="perms[]" value="/customers.php"> Cariler</label><br>
      <label><input type="checkbox" name="perms[]" value="/sales.php"> Satış Listesi</label><br>
      <label><input type="checkbox" name="perms[]" value="/customer-statement.php"> Cari Ekstresi</label>
    </div>
    <div style="align-self:end">
      <button class="btn" name="create" value="1">Kullanıcı Oluştur</button>
    </div>
  </form>
</div>
<div class="card">
  <h3>Mevcut Kullanıcılar</h3>
  <table class="table"><thead><tr><th>ID</th><th>Kullanıcı</th><th>Rol</th><th>İzinler</th></tr></thead><tbody>
    <?php foreach($users as $u): ?>
      <tr><td><?= $u['id'] ?></td><td><?= htmlspecialchars($u['username']) ?></td><td><span class="badge"><?= htmlspecialchars($u['role']) ?></span></td><td><code><?= htmlspecialchars($u['perms_json']) ?></code></td></tr>
    <?php endforeach; ?>
  </tbody></table>
</div>
<?php include __DIR__ . '/includes/ui-footer.php'; ?>